<?php

/* -----------------------------------------------------------------
 * 	$Id: kelkoo_basis.php 717 2013-11-05 15:38:31Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	(c) 2013     Gambio GmbH - www.gambio.de
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */

class Kelkoo_Basis {

    var $v_export_type;
    var $v_module_name;
    var $v_module_homepage;
    var $v_module_format;
    var $v_module_export_filename;
    var $v_filename;
    var $v_keyname;
    var $v_linkname;
    var $v_delimiter;
    var $v_enclosure;
    var $v_field_filename;
    var $v_field_customers_groups;
    var $v_field_currency;
    var $v_field_shipping_costs;
    var $v_field_shipping_costs_free;
    var $v_field_attributes;
    var $v_field_campaign;
    var $v_field_export;

    function Kelkoo_Basis() {
        $this->formSettings();
    }

    function formSettings() {
        $this->v_export_type = 'comparison';
        $this->v_module_name = 'Kelkoo Basis';
        $this->v_module_homepage = 'www.kelkoo.de';
        $this->v_module_format = 'txt';
        $this->v_module_export_filename = 'kelkoo_basis.txt';
        $this->v_filename = 'kelkoo_basis.php';
        $this->v_keyname = 'KELKOOBASIS';
        $this->v_linkname = 'kelkoo basis';
        $this->v_delimiter = "\t";
        $this->v_enclosure = '';
        $this->v_field_filename = true;
        $this->v_field_customers_groups = true;
        $this->v_field_currency = true;
        $this->v_field_shipping_costs = true;
        $this->v_field_shipping_costs_free = true;
        $this->v_field_attributes = true;
        $this->v_field_campaign = true;
        $this->v_field_export = true;
    }

    function formAddOn() {
        
    }

    function formatResults($p_products_array) {
        $p_products_array['products_availability'] = 'Nein';
        if ($p_products_array['products_availability'] >= date("Y-m-d H:i:s", time()))
            $p_products_array['products_availability'] = 'Ja';
        if ((int) $p_products_array['products_availability'] == 0)
            $p_products_array['products_availability'] = 'Ja';
        $p_products_array['products_description'] = str_replace("\t", "", no_html($p_products_array['products_description']));
        if (strlen($p_products_array['products_description']) > 150) {
            $p_products_array['products_description'] = substr($p_products_array['products_description'], 0, strpos($p_products_array['products_description'], ' ', 140)) . '...';
        }
        $p_products_array['products_price'] = number_format((double) $p_products_array['products_price'], 2, ',', '');
        $p_products_array['baseprice'] = number_format((double) $p_products_array['baseprice'], 2, ',', '');
        $p_products_array['products_shipping_costs'] = number_format((double) $p_products_array['products_shipping_costs'], 2, ',', '');
        $p_products_array['products_availability'] = '003';
        return($p_products_array);
    }

    function exportScheme() {
        $t_csv_fields_array = array();
        $t_csv_fields_array['products_link'] = 'url';
        $t_csv_fields_array['products_name'] = 'title';
        $t_csv_fields_array['products_description'] = 'description';
        $t_csv_fields_array['products_price'] = 'price';
        $t_csv_fields_array['products_id'] = 'offerid';
        $t_csv_fields_array['products_image_1'] = 'image';
        $t_csv_fields_array['products_availability'] = 'availability';
        $t_csv_fields_array['products_shipping_costs'] = 'deliverycost';
        $t_csv_fields_array['products_shippingtime'] = 'deliveryTime';
        $t_csv_fields_array['baseprice'] = 'baseprice';
        return($t_csv_fields_array);
    }

}

?>